return function(_, CanvasMetrics)

function CanvasMetrics:pixelSize()
    return 1 / self:pointScale()
end

function CanvasMetrics:growthAdjustment()
    return self:pointScale() ^ -0.5
end

function CanvasMetrics:alignToPixelEdge(x, y)
    local rect = self:rect()
    local pixelSize = 1 / self:pointScale()
    x = rect.left + math.floor(0.5 + (x - rect.left) / pixelSize) * pixelSize
    y = rect.top - math.floor(0.5 + (rect.top - y) / pixelSize) * pixelSize
    return x, y
end

function CanvasMetrics:alignToPixelCenter(x, y)
    local rect = self:rect()
    local pixelSize = 1 / self:pointScale()
    x = rect.left + math.floor((x - rect.left) / pixelSize) * pixelSize + pixelSize / 2
    y = rect.top - math.floor((rect.top - y) / pixelSize) * pixelSize - pixelSize / 2
    return x, y
end

end
